UNIT XCI;

INTERFACE

TYPE
  Real2 = extended;
  results = Record
               upper : real2;
               lower : real2;
            End; { results }


PROCEDURE Binomial( success, total : longint;
                    prob           : real2;
                    VAR W, F, M, C : results );

function WilsonUpper( success, total: integer; prob : double ) : double;
stdcall;
function WilsonLower( success, total: integer; prob : double ) : double;
stdcall;
function FleissUpper( success, total: integer; prob : double ) : double;
stdcall;
function FleissLower( success, total: integer; prob : double ) : double;
stdcall;
function MidPointUpper( success, total: integer; prob : double ) : double;
stdcall;
function MidPointLower( success, total: integer; prob : double ) : double;
stdcall;
function ClopperUpper( success, total: integer; prob : double ) : double;
stdcall;
function ClopperLower( success, total: integer; prob : double ) : double;
stdcall;
procedure init;

IMPLEMENTATION

type resrectype = record
                    success : longint;
                    total   : longint;
                    prob    : real2;
                    wilson  : results;
                    fleiss  : results;
                    mid_p   : results;
                    clopper : results;
                  end;

VAR  resrec : resrectype;

Function LnFact(n : longint) : extended;
var
   b1 : extended;
begin
  if n > 253 then
    begin
      n := n+1;
      LnFact := n*(ln(n)-1)-ln(sqrt(n/2/pi))+1/(12*n);
    end
    else begin
      n := n+3;
      b1 := n+1/n/4; b1 := n+1/b1/30;
      b1 := exp(1/b1/12-n)/sqrt(n/2/pi);
      LnFact := n*ln(n)+ln(b1/(n-1)/(n-2));
    end
end; { LnFact }

Function COMB(m1, a : longint) : extended;
begin
  COMB := LnFact(m1)-LnFact(a)-LnFact(m1-a);
end; { COMB }

Procedure Swapreal(var n, m : real2);
var x : real2;
begin
  x := n; n := m; m := x;
end; { Swapreal }

Procedure SwapInteger(var n, m: integer);
var x : integer;
begin
  x := n; n := m ; m := x;
end; { SwapInteger }

procedure Sub1(a, b, m1 : integer; fl0, fl1, r0, r8, a1 : real2; var d3 : real2);
label LE ;
var d1, d2, p0, i, r1, r2, r3, r4, r5, r7 : real2;
begin
     if fl1 = 1 then
        begin
           r2 := (a+1) * 2; r1 := b * 2;
        end else
        begin
           r2 := a * 2; r1 := (b+1) * 2;
        end; { if }
     r3 := r8; r7 := 2;
     r4 := exp((r2*0.5)*ln(abs(r8)));
     i := (r1-2) * 0.5;
     if i <> 0 then
     begin
        r3 := 1 - r3; a1 := r3 * (r2*0.5); r5 := a1 + 1;
        i := i - 1;
        if i > 0 then
        repeat
           r2 := r2 + 2; r7 := r7 + 2;
           a1 := a1 * ((r2*r3)/r7); r5 := r5 + a1;
           i := i - 1;
        until i = 0;
        d1 := r4 * r5;
     end
     else
     d1 := r4;
     if fl1 = 1 then d2 := 1 - d1 else d2 := d1;
     if fl0 = 1 then goto LE;
     p0 := exp(comb(m1,a) + a * ln(abs(r8)) + b * ln(abs(1-r8))) * 0.5;
     d2 := d2 - p0;
LE:  d3 := r0 + d2;
end;

procedure XL(a, m1, fl0 : integer; p3 : real2; var  l, u : real2);

var b, a1 : integer;
    x , fl1, fl2, fl3, fl4 : real2;
    d1, d2, d3, p, r0, r6, r8, r9, s1, s3 : real2;
    flag, flag1 :boolean;

begin
     x:= 0.01745506493; a1 := 0; b := m1 - a;
     fl1 := 0; fl2 := 0; fl3 := 1; fl4 := 0;
     if a = 0 then
        begin
          fl3 := 0;
          SwapInteger(a,b);
        end;
     if (a/m1 < 0.5 ) AND ( a <> 0 )then
        begin fl4 := 1; SwapInteger(a,b); end;
     s1:= a/m1; s3 := s1 * (1-s1); r0 := (p3/100-1) * 0.5;
     if b = 0 then fl2 := 1;
  REPEAT
     p := sqrt(s3/m1);
     if p = 0 then p := p + 1/a - x;
     if fl1 = 1 then p := -p;
     r8 := s1 - p; r9 := r8;
     Sub1(a, b, m1, fl0, fl1, r0, r8, a1, d3);
     r6 := d3; r8 := r8 - x;
     repeat
        Sub1(a, b, m1, fl0, fl1, r0, r8, a1, d3 );
        d2 := d3; d1 := r8;
        d3 := ((r9-r8)/(r6-d3)) * d2;
        r8 := r8 - d3; r9 := d1; r6 := d2;
     until abs(d3/r8) <= 1.0E-10;
     if fl4 = 1 then r8 := 1 - r8;
     flag := true;
     if fl3 = 1 then
        begin
          fl3 := 0;
          { goto LC; }
          flag := false
        end;
     flag1 := true;
     IF flag THEN
       BEGIN
        if fl2 = 1 then
          begin fl2 := 0; r8 := 1 - r8; l := 0; end;
          u := abs(r8);
        if fl4 = 1 then
          begin fl4 := 0; SwapReal(l,u); end;
        flag1 := false;
        {goto LK;}
      END;
    IF flag1 THEN
      BEGIN
        l := abs(r8);
        flag := true;
        if fl2 = 1 then
            begin fl2 := 0; u := 1 ; flag := false; end;
        IF flag then fl1 := 1;
      END;
  UNTIL ( flag = false) OR ( flag1 = false );
end;  { XL }

Function InverseNormal(q : real2) : real2;
const
   c0 = 2.515517;
   c1 = 0.802853;
   c2 = 0.010328;
   d1 = 1.432788;
   d2 = 0.189269;
   d3 = 0.001308;
var
   den, y, t : real2;
begin
   if q <= 0.5 then
        t := sqrt(ln(1/sqr(q)))
   else
        t := sqrt(ln(1/sqr(1-q)));
   y := c0 + (c1+c2*t)*t;
   den := 1 + t * (d1+t*(d2+d3*t));
   InverseNormal := round((t-y/den)*1000) / 1000;
end; { InverseNormal }

Procedure Fleiss(a,n4,z : real2;  var l,u : real2);
var c1, c2, c3, c4, c5, c6, c7, c8, p, q  : real2;
  begin  c3 := 0; c7 := 0;
     p := a/n4; q := 1-p; c1 := 2*n4*p;
     c2 := sqr(z); c6 := 2*(n4+c2);
     c3 := c1+c2; c4 := c3-1; c5 := z*sqrt(c2-(2+1/n4)+4*p*(n4*q+1));
     c7 := c3+1; c8 := z*sqrt(abs(c2+(2-1/n4)+4*p*(n4*q-1)));
     l := abs((c4-c5)/c6); u := abs((c7+c8)/c6);
  end; { Fleiss }

Procedure Wilson(a,n4,z : real2;  var l0,u0 : real2);
var  c4, c5, c6  : real2;
  begin
     c5 := a/n4; c4 := sqr(z)/(2*n4)+c5;
     c5 := c5*(1-c5)/n4;
     c5 := z*sqrt(c5+sqr(z)/(4*sqr(n4)));
     c6 := 1+sqr(z)/n4;
     l0 := abs((c4-c5)/c6); u0 := abs((c4+c5)/c6);
  end; { Wilson }

Procedure Zero(a, b, fl0         :longint;
               var root, x0, equ :extended;
               var error, p1, m1 :longint);
label AA, BB, A1, B1 ;
var xn,xp,x1,x2,fn,fp,fx,f0,f1,f2,p0,tol : extended;
    iter, maxit, j : longint;
      found : boolean;
begin
  tol := 0.00001; maxit := 100;
  iter := 0; fn := 0; fp := 0; xn := 0; xp := 0;
  repeat f0 := 0; p0 := 0; fx := 0;
     for j := p1 to m1 do
        begin
           f0 := f0+exp(comb(m1,j)+j*ln(x0)+(m1-j)*ln(1-x0));
           if fx = f0 then goto A1;
           fx := f0;
        end;
A1:  if fl0 = 1 then goto AA;
     p0 := exp(comb(m1,a)+a*ln(x0)+b*ln(1-x0))*0.5;
     f0 := f0+p0;
AA:  f0 := f0-equ;
     if f0 > 0 then
        begin xp := x0; fp := f0; x0 := x0-x0/10; end
        else
        begin xn := x0; fn := f0; x0 := x0+x0/10; end;
  until (fp<>0) and (fn<>0);
     f0 := fp; x0 := xp; f1 := fn; x1 := xn;
     if abs(f0) < abs(f1) then
        begin SwapReal(x0,x1); SwapReal(f0,f1); end;
     found := (f1=0);
   while (not found) and (iter<=maxit) do
   begin
     inc(iter);
     x2 := x1-f1*(x1-x0)/(f1-f0); f2 := 0; p0 := 0; fx := 0;
     for j := p1 to m1 do
        begin
           f2 := f2+exp(comb(m1,j)+j*ln(x2)+(m1-j)*ln(1-x2));
           if fx = f2 then goto B1;
           fx := f2;
        end;
B1:  if fl0 = 1 then goto BB;
     p0 := exp(comb(m1,a)+a*ln(x2)+b*ln(1-x2))*0.5;
     f2 := f2+p0;
BB:  f2 := f2-equ;
     x0 := x1; f0 := f1; x1 := x2; f1 := f2;
     found := abs(f2) < tol;
   end; { while }
     root := x1;
end; { Zero }


Procedure ExLim(a,m1,fl0 : longint; p3, l1, u0 : real2; var l,u : real2);
var  p, x, za : real2;
    equ : extended;
    b, j, p1 : longint;
  begin
     l := 0; u := 0; x := 0; b := m1-a;
     p := l1; za := (100-p3)/200; equ := za;
     if fl0 = 1 then p1 := a else p1 := a+1;
     Zero(a,b,fl0,x,p,equ,j,p1,m1);
     l := x; x := 0;
     p := u0; p1 := a + 1; equ := 1-za;
     Zero(a,b,fl0,x,p,equ,j,p1,m1);
     u := x;
   end; { ExLim }


Procedure BIN(na,n,fl0 : integer; alp : extended; var p1,p2 : extended);
   var xa,x,p0,phat,com,diff,ph1,ph2,pq,delta,est,
    alp1,alp2,bin,alph,ptemp  :  extended;
    flag,ka,i,k : integer;
label A,B,3,5,20,30,99,100,105,130,199,200,300,400;
begin
   alp := (100-alp)/100;
   alp1 :=  1-alp/2;
   xa := na;
   x := n;
   phat := xa/x;
   ptemp := phat;
   flag := 0;
   if ptemp < 0.5 then goto 3;
   ptemp := 1-ptemp;
   na := n-na;
   flag := 1;
3: if phat = 0 then goto 300;
   if phat = 1 then goto 400;
   delta := ptemp/2;
   ph1 := delta;
5: est := 0;
   delta := delta/2;
   for i := 1 to na do
   begin
      k := i-1 ;
      com := COMB(n,k);
      pq := ln(ph1)*k+ln(1-ph1)*(n-k);
      bin := com+pq;
      est := est+exp(bin);
   end;
   if fl0 = 1 then goto A;
      p0 := exp(COMB(n,na)+na*ln(ph1)+(n-na)*ln(1-ph1))*0.5;
      est := est+p0;
A: diff := alp1-est;
   if abs(diff) < 0.000001 then goto 99;
   if diff < 0 then goto 30;
   ph1 := ph1-delta; goto 5;
30: ph1 := ph1+delta; goto 5;
99: if flag = 0 then p1 := ph1;
    if flag = 1 then p2 := 1-ph1;
100: alp2 := alp/2;
     delta := (1-ptemp)/2;
     ph2 := ptemp+delta;
105: est := 0;
     delta := delta/2;
     ka := na+1;
     for i := 1 to ka do
     begin
        k := i-1;
        com := COMB(n,k);
        pq := ln(ph2)*k+ln(1-ph2)*(n-k);
        bin := com+pq;
        est := est+exp(bin);
     end;
     if fl0 = 1 then goto B;
        p0 := exp(COMB(n,na)+na*ln(ph2)+(n-na)*ln(1-ph2))*0.5;
        est := est-p0;
B:   diff := alp2-est;
     if abs(diff) < 0.000001 then goto 199;
     if diff < 0 then goto 130;
     ph2 := ph2-delta;
     goto 105;
130: ph2 := ph2+delta;
     goto 105;
199: if flag = 0 then p2 := ph2;
     if flag = 1 then p1 := 1-ph2;
     if flag = 1 then na := n-na;
200: exit;
300: p1 := 0;
     alph := alp/2;
     if fl0 = 0 then
     p2 := 1-exp(ln(alph)/(x*1.23138))
     else
     p2 := 1-exp(ln(alph)/x);
     goto 200;
400: p2 := 1;
     alph := alp/2;
     if fl0 = 0 then
     p1 := exp(ln(alph)/(x*1.23138))
     else
     p1 := exp(ln(alph)/x);
     goto 200;
end;    { BIN }


PROCEDURE Binomial( success, total : longint;
                     prob           : real2;
                     VAR W, F, M, C : results );

VAR
  z, p, p4, plim : real2;
  fl0, fl5 : integer;
  tempres : results;

BEGIN
  prob := prob * 100;
  z := InverseNormal(( 100 - prob ) / 200 );
  F.lower := 0; F.upper := 0;
  W.lower := 0; W.upper := 0;
  Wilson( success, total, z, W.lower, W.upper );
  Fleiss( success, total, z, F.lower, F.upper );
  if success = total then F.upper := 1.0;
  if success = 0 then
       begin W.lower := 0; F.lower := 0; end;
  p4 := success / total;
  p := p4 * 100;
  plim := 0; fl5 := 0;
  plim := total * 0.0048 - 1.1;
  if (total > 300) and (p < plim) or (total > 300) and (p > 92)
    or (total > 3000) and (p > 76) or (total > 5000) then fl5 := 1;
     { zero returned values }
  if fl5 <> 1 then
    Begin
      fl0 := 0;
      REPEAT
        XL(success,total,fl0,prob,tempres.lower, tempres.upper);
        WITH tempres do
          if (upper = 0.0) or (upper > 1) then upper := 1.0;
        if fl0 = 0 then
          BEGIN
            m.lower := tempres.lower;
            m.upper := tempres.upper
          END
        else
          BEGIN
            C.lower := tempres.lower;
            c.upper := tempres.upper;
          END;
        {If fl0 = 1 THEN goto GG;}
        fl0 := fl0 + 1;
      UNTIL fl0 > 1;
    End;
    if not ( fl0 > 0 ) or (success > 23000) or (total > 32000) then
      BEGIN
        fl0 := 0;
        REPEAT
          if (success >= 10) and (p <= 85) or (success > 0)
                and ((total > 4000) and (p < 80)) then
              begin
                EXLIM( success, total, fl0, prob, F.lower, W.upper,
                       tempres.lower, tempres.upper );
              end
            else
              begin
                BIN(success,total,fl0,prob,tempres.lower,tempres.upper);
              end;
          if fl0 = 0 then
              begin
                m.lower := tempres.lower; m.upper := tempres.upper
              end
            else
              begin
                C.lower := tempres.lower; c.upper := tempres.upper;
              end;
          fl0 := fl0 + 1; {goto II;}
        UNTIL fl0 > 1;
       END;
     resrec.success := success;
     resrec.total := total;
     resrec.prob := prob;
     resrec.wilson.upper := w.upper;
     resrec.wilson.lower := w.lower;
     resrec.fleiss.upper := f.upper;
     resrec.fleiss.lower := f.lower;
     resrec.mid_p.upper := m.upper;
     resrec.mid_p.lower := m.lower;
     resrec.clopper.upper := c.upper;
     resrec.clopper.lower := c.lower;
END;

FUNCTION Valid_data( success, total: integer; prob : double ) : boolean;

BEGIN
  Valid_Data := ( success >= 0 ) AND ( total >= success ) AND
                ( prob > 0 ) AND ( prob < 1 );
END;

function WilsonUpper( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
  IF NOT Valid_data( success, total, prob ) THEN
      WilsonUpper := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        WilsonUpper := resrec.wilson.upper;
      END;
END;

function WilsonLower( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      WilsonLower := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        WilsonLower := resrec.wilson.lower;
      END  
END;

function FleissUpper( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      FleissUpper := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        FleissUpper := resrec.fleiss.upper;
      END  
END;

function FleissLower( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      FleissLower := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        FleissLower := resrec.fleiss.lower;
      END;
END;

function MidPointUpper( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      MidPointUpper := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        MidPointUpper := resrec.mid_p.upper;
      END  
END;

function MidPointLower( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      MidPointLower := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        MidPointLower := resrec.mid_p.lower;
      END;
END;

function ClopperUpper( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;
BEGIN
   IF NOT Valid_data( success, total, prob ) THEN
      ClopperUpper := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        ClopperUpper := resrec.clopper.upper;
      END
END;

function ClopperLower( success, total: integer; prob : double ) : double;
stdcall;

VAR W, F, C, M : results;

BEGIN
    IF NOT Valid_data( success, total, prob ) THEN
      ClopperLower := -1
    ELSE
      BEGIN
        IF NOT (( success = resrec.success ) AND ( total = resrec.total )
          AND ( prob = resrec.prob )) THEN
        Binomial( success, total, prob, W, F, M, C );
        ClopperLower := resrec.clopper.lower;
      END;
END;

PROCEDURE Init;

BEGIN
  with resrec do
    begin
      success := 0;
      total := 0;
      prob := 0;
      wilson.upper := 0;
      wilson.lower := 0;
      fleiss.upper := 0;
      fleiss.lower := 0;
      mid_p.upper := 0;
      mid_p.lower := 0;
      clopper.upper := 0;
      clopper.lower := 0;
    end;
END;

END.
