library Fisher32;

{ Fisher exact probability routines in 32-bit DLL ( for Windows95,
  compatible with Delphi and VBasic ( in the form of Excel ).
  Should be compatible with other Windows95 applications, though not tested.

  By Richard Muirhead ( rmuirhead@compuserve.com ), adapted from
  source code by  Ray Simons in MISCSTAT.EXE }

FUNCTION LnFact( n : double ) : double;

VAR n1 : extended;

BEGIN
  IF ( n > 250 ) THEN
    BEGIN
      n := n+1;
      LnFact := n*(ln(n)-1)-ln(sqrt(n/2/pi))+1/(12*n);
    END
   ELSE
    BEGIN
      n := n+3;
      n1 := exp(1/((1/((1/((0.36895/n+n)*4)+n)*30)+n)*12)-n);
      LnFact := ln(n1/sqrt(n/2/pi)*exp(n*ln(n))/(n-1)/(n-2));
    END
END;   { LnFact }

Function COMB( m1, a : double ) : double;

BEGIN
  COMB := LnFact(m1)-LnFact(a)-LnFact(m1-a);
END; { COMB }

PROCEDURE Swapreal( VAR n,m : double );

VAR x : double;

BEGIN
  x := n; n := m; m := x;
END;  { Swapreal }

PROCEDURE Exact( a, b, c, d : double; VAR p0, p1, p2, p4 : double ); stdcall;
{ copied from original, but modified to take the following parameters:-
         a, b, c, d ; counts from 2x2 contingency table
  returns : p0 : Fisher point probability
            p1 : Fisher 1- tailed probability
            p2 : Fisher 2-tailed probability
            p4 : Fisher mid-point 1-tail ( 2-tail = 2*p4 )
}

VAR a4, b4, c4, d4, h, n, n1, n0, m1,
    r0, r1, r6, r9, x               : double;
    flag                            : integer;

BEGIN
  n1 := a+c; n0 := b+d; m1 := a+b; h := c+d; n := n1+n0;
  flag := 0;
  IF a*d>b*c THEN
    BEGIN
      Swapreal(a,c);
      Swapreal(b,d);
      flag := 1;
    END;
  a4 := 0; b4 := 1.0; c4 := 1.0; x := 1.0; r1 := a; r6 := d;
  r9 := b+1; r0 := c+1;
  REPEAT
    x := x*r1*r6/(r9*r0); b4 := x+b4; c4 := x+c4;
    r1 := r1-1; r6 := r6-1; r0 := r0+1; r9 := r9+1;
  UNTIL x<1.0E-8;
  r9 := b; r0 := c; r1 := a+1; r6 := d+1; x := 1.0;
  REPEAT
    x := x*r9*r0/(r1*r6); c4 := x+c4;
    if (x<=1.0001) then  a4 := x+a4;
    r1 := r1+1; r6 := r6+1; r0 := r0-1; r9 := r9-1;
  UNTIL x<1.0E-8;
  p1 := abs(b4/c4);
  p2 := abs((a4+b4)/c4);
  p0 := exp(Comb(n1,a)+Comb(n0,b)-Comb(n,m1));
  p4 := p1-(p0/2);
  IF ( flag = 1 ) THEN
    BEGIN
      Swapreal(a,c);
      Swapreal(b,d);
      flag := 0;
    END;
END;

FUNCTION Valid_Data( a, b, c, d : integer ): boolean;

BEGIN
  Valid_Data := ( a >= 0 ) AND ( b >= 0 ) AND ( c >= 0 ) AND ( d >= 0 );
END;

FUNCTION FisherMP1( a, b, c, d : integer ): double; stdcall;
{ to return Fisher mid-p 1-tail
  a, b, c, d : 2x2 contingency table

  Fisher mid-p 2-tail = 2*FisherMP
}

VAR
  p0, p1, p2, p4 : double;

BEGIN
  IF Valid_Data( a, b, c, d ) THEN
    BEGIN
      Exact ( a, b, c, d, p0, p1, p2, p4 );
      FisherMP1 := p4;
    END
  ELSE FisherMP1 := -1;
END;

FUNCTION FisherMP2( a, b, c, d : integer ): double; stdcall;

VAR r : double;

BEGIN
  r := FisherMP1( a, b, c, d );
  IF ( r >= 0 ) THEN r := 2*r;
  IF ( r >= 1 ) THEN r := 1; 
  IF ( r < 0 ) THEN FisherMP2 := -1
    ELSE FisherMP2 := r;
END;

FUNCTION FisherPP( a, b, c, d : integer ): double; stdcall;
{ returns Fisher point probability value
  a, b, c, d : 2x2 contingency table
}

VAR
  p0, p1, p2, p4 : double;

BEGIN
   IF Valid_Data( a, b, c, d ) THEN
      BEGIN
        Exact ( a, b, c, d, p0, p1, p2, p4 );
        FisherPP := p0;
      END
    ELSE FisherPP := -1;
END;

FUNCTION Fisher1( a, b, c, d : integer ): double; stdcall;
{ returns Fisher 1-tailed probability test
  a, b, c, d : 2x2 contingency table
}

VAR
  p0, p1, p2, p4 : double;

BEGIN
  IF Valid_Data( a, b, c, d ) THEN
      BEGIN
        Exact ( a, b, c, d, p0, p1, p2, p4 );
        Fisher1 := p1;
      END
    ELSE Fisher1 := -1;
END;

FUNCTION Fisher2( a, b, c, d : integer ): double; stdcall;
{ returns Fisher 2-tailed probability test
  a, b, c, d : 2x2 contingency table
}

VAR
  p0, p1, p2, p4 : double;

BEGIN
  IF Valid_Data( a, b, c, d ) THEN
      BEGIN
        Exact ( a, b, c, d, p0, p1, p2, p4  );
        IF ( p1 = p2 ) THEN p2 := 2*p1;
        Fisher2 := p2;
      END
    ELSE Fisher2 := -1;
END;



exports
   Fisher1 index 1,
   Fisher2 index 2,
   FisherMP1 index 3,
   FisherMP2 index 4,
   FisherPP index 5,
   Exact index 6;

begin end.


